{-# LANGUAGE ScopedTypeVariables #-}
module Main where

import Queue
import Test.Tasty
import qualified Test.Tasty.QuickCheck as QC
import Test.Tasty.QuickCheck((==>),(===))

-- Arbitrary-Instanz f�r Queues
-- Erzeugt eine Queue zuf�lliger L�nge zwischen 0 und 20, 
-- gef�llt mit zuf�lligen Werten.
instance QC.Arbitrary a=> QC.Arbitrary (Qu a) where
  arbitrary = do
    size <- QC.choose (0, 20)
    rsz  <- QC.choose (0, size `div` 5)
    els  <- QC.vector size     
    return $ foldr (\_ q-> deq q) (foldr enq empty els) [1.. rsz::Int]

main =
  defaultMain $ localOption (QC.QuickCheckTests 5000) $
    testGroup "All queue tests" [prop1, prop2, prop3, prop4, prop5]

prop1 = QC.testProperty "first_empty" $ \(a:: Int)-> 
  first (enq a empty) == a

prop2 = QC.testProperty "first_enq" $ \a (q :: Qu Int)->
  q /= empty ==> first (enq a q) === first q

prop3 = QC.testProperty "deq_enq_empty" $ \(a:: Int)->
  deq (enq a empty) === empty

prop4 = QC.testProperty "deq_enq" $ \a (q :: Qu Int)->
  q /= empty ==> deq (enq a q) === enq a (deq q)

prop5 = QC.testProperty "enq not empty" $ \a (q :: Qu Int)->
  enq a q /= empty

