{-# LANGUAGE FlexibleInstances, ScopedTypeVariables #-}
module Main where

-- import MapFun
-- import MapList
import MapTree
import Prelude hiding (lookup)    

import Test.Tasty
import qualified Test.Tasty.QuickCheck as QC
import Test.Tasty.QuickCheck((==>),(===))

-- Arbitrary-Instanz f�r Map. 
-- Erzeugt eine Map zuf�lliger L�nge zwischen 0 und 20, gef�llt mit zuf�lligen Werten.
instance (Ord a, QC.Arbitrary a, QC.Arbitrary b)=>
          QC.Arbitrary (Map a b) where
  arbitrary = do
    size <- QC.choose (0, 20)
    a <- QC.vector size
    b <- QC.vector size
    return (foldl (\s (a, v)-> put a (Just v) s) empty (zip a b))

-- Die Eigenschaften (thin interface)

-- Lesen der leeren Map
prop1 :: TestTree
prop1 = QC.testProperty "read_empty" $ \a-> 
  lookup a (empty :: Map Int String) == Nothing 
 
-- Löschen in der leeren Map
prop2 :: TestTree
prop2 = QC.testProperty "delete_empty" $ \a-> 
  put a Nothing (empty :: Map Int String) == empty
 
-- Lesen an derselben Stelle
prop3 :: TestTree
prop3 = QC.testProperty "lookup_put eq" $ \a v (s :: Map Int String)->
  lookup a (put a v s) == v

-- Lesen an anderer Stelle
prop4 :: TestTree
prop4 = QC.testProperty "lookup_put other" $ \a b v (s :: Map Int String)->
  a /= b ==> lookup a (put b v s) == lookup a s
  
-- Schreiben an derselben Stelle
prop5 :: TestTree
prop5 = QC.testProperty "put_put eq" $ \a v w (s :: Map Int String)->
  put a w (put a v s) == put a w s

-- Schreiben an anderer Stelle
prop6 :: TestTree
prop6 = QC.testProperty "put_put other" $ \a v b w (s :: Map Int String)->
  a /= b ==> put a v (put b w s) == put b w (put a v s)


main =
  defaultMain $ localOption (QC.QuickCheckTests 5000) $
    testGroup "All map tests"
    [prop1, prop2, prop3, prop4, prop5, prop6]

