module Queue2(Qu, empty, enq, first, deq) where

import Data.List(intercalate)

-- This is an alternative but faulty implementation of Queues

-- A Queue is given by two lists
data Qu alpha = Qu [alpha] [alpha]

-- The empty Q
empty :: Qu alpha
empty = Qu [] []

-- Enqueue 
enq   :: alpha-> Qu alpha-> Qu alpha
enq x (Qu [] ys) = Qu (x: reverse ys) []
enq x (Qu xs ys) = Qu xs (x:ys)

-- Front of Q
first :: Qu alpha-> alpha  
first (Qu [] [])    = error "Queue: first of empty Q"
first (Qu [] ys)    = last ys 
first (Qu (x:xs) _) = x

-- Dequeue
deq   :: Qu alpha-> Qu alpha
deq (Qu [] [])     = error "Queue: deq of empty Q"
deq (Qu [] ys)     = Qu (tail (reverse ys)) []
deq (Qu (_:xs) ys) = Qu xs ys

-- Equality for queues.
-- Two queues are equal their content is the same.
instance Eq alpha=> Eq (Qu alpha) where
  Qu xs1 ys1 == Qu xs2 ys2 =
    xs1 ++ reverse ys1 == xs2 ++ reverse ys2

-- Show (needed with quickcheck to show failures)
-- Displays front of queue to the right, as on the slides
instance Show a=> Show (Qu a) where
  show (Qu xs ys) =
    "<"++ intercalate " -> " (map show ys)
     ++ " * ->" ++ intercalate " -> " (map show $ reverse xs) ++ ">"
