module VTree where

import Debug.Trace(trace)

{-- vtree --}
data VTree alpha = NT alpha [VTree alpha]
{-- end --}
                   deriving Show

-- Foldr function for variadic trees:
{-- foldT --}
foldT :: (alpha-> [beta]-> beta)-> VTree alpha-> beta
foldT f (NT a ns) = f a (map (foldT f) ns)
{-- end --}

-- Map for variadic trees:
{-- fmap --}
instance Functor VTree where
  fmap f (NT a ns) = NT (f a) (map (fmap f) ns)
{-- end --}

-- A path in the tree is a list of node labels
type Path alpha = [alpha]

-- A leaf has no children
isLeaf :: VTree alpha-> Bool
isLeaf (NT a ns) = null ns

-- All possible traversals, depth first via fold.
-- Does not work for graphs (infinite trees), as it will diverge!
{-- dfs1 --}
dfs1 :: VTree alpha-> [Path alpha]
dfs1 = foldT add where
  add a [] = [[a]]
  add a ps = [ a:p | p <- concat ps]
{-- end --}  

-- This diverges as well!
{-- dfs2 --}
dfs2 :: Eq alpha=> VTree alpha-> [Path alpha]
dfs2 = foldT add where
  add a [] = [[a]]
  add a ps = [a:p | p <- concat ps, not (a `elem` p) ]
{-- end --}  

