module TakeByFold where

-- import Prelude hiding (take)

-- Terminiert nicht für zyklische Listen (wegen foldl)
takel :: Int-> [alpha]-> [alpha]
{-- takel --}
takel i = snd . foldl (\(c, p) a-> (c+1, if c< i then (p++[a]) else p)) (0, [])
{-- end --}

-- Geschummelt wegen zip
taker1 :: Int-> [alpha]-> [alpha]
{-- taker1 --}
taker1 i = foldr (\(j, x) xs-> if j<= i then x:xs else xs) [] . zip [1..i]
{-- end --}

-- Geht auch einfacher:
taker1' :: Int-> [alpha]-> [alpha]
taker1' i = map snd . zip [1.. i]

-- Hier eine echte Implementation mit foldr (terminiert nicht für zyklische Listen)
taker :: Int-> [alpha]-> [alpha]
{-- taker --}
taker i xs = 
  snd $ foldr (\a (c, p)-> (c+1, if c >= length xs-i then a:p else [])) (0, []) xs
{-- end --}
