module VTreeExamples where

import VTree

-- A simple example exhibiting difference between dfs and bfs
{-- simple --}
l00 = NT 0 [l01, l03]
l01 = NT 1 [l02]
l02 = NT 2 [l00, l03]
l03 = NT 3 [l00]
{-- end --}

-- The example labyrinth with cycles:
maze02 = m10
m00 = NT 0 [m01]
m10 = NT 1 [m00]   -- "Entrance"
m20 = NT 2 [m10, m21] -- Introduces a cycle 
m30 = NT 3 [m20]
m40 = NT 4 []
m01 = NT 5 [m02, m11]
m11 = NT 6 []
m21 = NT 7 [] 
m31 = NT 8 [m30, m41]
m41 = NT 9 [m40, m42]
m02 = NT 10 [m12]
m12 = NT 11 [m13]
m22 = NT 12 [m32]
m32 = NT 13 [m31]
m42 = NT 14 []
m03 = NT 15 [m02] -- Introduces a cycle
m13 = NT 16 [m03, m23] 
m23 = NT 17 [m22, m24]
m33 = NT 18 [m32] -- Introduces a cycle
m43 = NT 19 []
m04 = NT 20 [m03] -- Introduces a cycle
m14 = NT 21 [m04]
m24 = NT 22 [m14, m34]
m34 = NT 23 [m33, m44]
m44 = NT 24 [m43] -- "Exit"

