module VTree where

import Data.Maybe(listToMaybe, catMaybes)



data VTree alpha = NT alpha [VTree alpha]

-- Traverse a variadic tree, looking for a node
{-- traverse --}
traverse :: Eq alpha=> alpha-> VTree alpha-> Maybe [alpha]
traverse t vt = trav [] vt where
  trav p (NT l vs)
    | l == t = Just (reverse (l: p))
    | elem l p = Nothing
    | otherwise = select (map (trav (l: p)) vs)
{-- end --}

-- Select first sucessful option from a list of options, if it exists
select :: [Maybe alpha]-> Maybe alpha
select = listToMaybe . catMaybes

-- Depth-first search
{-- dfs --}
depth_first_search :: Eq alpha=> alpha-> VTree alpha-> Maybe [alpha]
depth_first_search t vt = trav [(vt, [])] where
  trav [] = Nothing
  trav ((NT l ch, p):rest) 
    | l == t    = Just (reverse (l:p))
    | elem l p  = trav rest
    | otherwise = trav (more++ rest) where
                    more = map (\c-> (c, l: p)) ch
{-- end --}

{-- bfs --}
breadth_first_search :: Eq alpha=> alpha-> VTree alpha-> Maybe [alpha]
breadth_first_search t vt = trav [(vt, [])] where
  trav [] = Nothing
  trav ((NT l ch, p):rest) 
    | l == t    = Just (reverse (l:p))
    | elem l p  = trav rest
    | otherwise = trav (rest ++ more) where
                    more = map (\c-> (c, l: p)) ch
{-- end --}

