module Primes where

-- Calculating primes with Eratosthenes
{-- sieve --}
sieve :: [Integer]-> [Integer]
sieve [] = []
sieve (p:ps) = p: sieve (filter (\q-> q `mod` p /= 0) ps)
{-- end --}

-- First n primes
{-- n_primes --}
n_primes :: Int-> [Integer]
n_primes n = take n (sieve [2.. ])
{-- end --}
