module LabExamples where

import Labyrinth

-- A simple example without cycles
{-- simple1 --}
s0 = TJnc 0 s1 s2
s1 = Dead 1
s2 = Pass 2 s3
s3 = TJnc 3 s1 s4
s4 = Dead 4
{-- end --}

-- A simple example with cycles
{-- simple2 --}
t0 = Pass 0 t2 
t1 = Pass 1 t0
t2 = Pass 2 t3
t3 = TJnc 3 t1 t4
t4 = Dead 4
{-- end --}

-- The larger example labyrinth without cycles:
maze01 = l10
l00 = Pass 0 l01
l10 = Pass 1 l00   -- "Entrance"
l20 = Pass 2 l21
l30 = Pass 3 l20
l40 = Dead 4
l01 = TJnc 5 l02 l11 
l11 = Dead 6
l21 = Dead 7 
l31 = TJnc 8 l30 l41
l41 = TJnc 9 l40 l42
l02 = Pass 10 l12
l12 = Pass 11 l13
l22 = Pass 12 l32
l32 = Pass 13 l31
l42 = Dead 14
l03 = Dead 15
l13 = TJnc 16 l03 l23 -- Pass 16 l03 <-- This change bisects the labyrinth
l23 = TJnc 17 l22 l24 
l33 = Dead 18 
l43 = Dead 19
l04 = Dead 20
l14 = Pass 21 l04
l24 = TJnc 22 l14 l34
l34 = TJnc 23 l33 l44
l44 = Pass 24 l43 -- "Exit"

-- The larger example labyrinth with cycles:
maze02 = m10
m00 = Pass 0 m01
m10 = Pass 1 m00   -- "Entrance"
m20 = TJnc 2 m10 m21 -- Introduces a cycle 
m30 = Pass 3 m20
m40 = Dead 4
m01 = TJnc 5 m02 m11 
m11 = Dead 6
m21 = Dead 7 
m31 = TJnc 8 m30 m41
m41 = TJnc 9 m40 m42
m02 = Pass 10 m12
m12 = Pass 11 m13
m22 = Pass 12 m32
m32 = Pass 13 m31
m42 = Dead 14
m03 = Pass 15 m02 -- Introduces a cycle
m13 = TJnc 16 m03 m23 
m23 = TJnc 17 m22 m24 
m33 = Pass 18 m32 -- Introduces a cycle
m43 = Dead 19
m04 = Pass 20 m03 -- Introduces a cycle
m14 = Pass 21 m04
m24 = TJnc 22 m14 m34
m34 = TJnc 23 m33 m44
m44 = Pass 24 m43 -- "Exit"

