module Fibonacci where

import Data.List(genericIndex)

-- Fibonacci, recursive
fib1 :: Integer-> Integer
fib1 0 = 1
fib1 1 = 1
fib1 n = fib1 (n-1)+ fib1 (n-2)

-- Sequence of Fibonacci numbers
fibs :: [Integer]
fibs = 1 : 1 : zipWith (+) fibs (tail fibs) 
  
-- Using that, Fibonacci recursive but in linear time
fib2 :: Integer-> Integer
fib2 n = genericIndex fibs n 

-- Alternativey, a non-recursive formulation
fib3 :: Integer-> Integer
fib3 n = round ((1/sqrt 5)*(((1+ sqrt 5)/2)^(n+1)-((1- sqrt 5)/2)^(n+1)))

{- But this is dodgy, as the floating point arithmetic starts to
   differ at 75 (at least on my machine). Try this:

*Fibonacci> (fib2 74, fib3 74)
(2111485077978050,2111485077978050)
*Fibonacci> (fib2 75, fib3 75)
(3416454622906707,3416454622906706)
 
  As I said earlier: floating point arithmetic considered harmful.
-}
