module Shoppe3 where

import Data.Maybe

-- Modellierung der Artikel.

data Apfelsorte = Boskoop | CoxOrange | GrannySmith 
             deriving (Eq, Show)

apreis :: Apfelsorte -> Int
apreis Boskoop = 55
apreis CoxOrange = 60
apreis GrannySmith = 50

data Kaesesorte = Gouda | Appenzeller  
             deriving (Eq, Show)

kpreis :: Kaesesorte -> Double
kpreis Gouda = 1450
kpreis Appenzeller = 2270

data Bio = Bio | Konv
           deriving (Eq, Show)

data Artikel = 
   Apfel Apfelsorte  | Eier
 | Kaese Kaesesorte  | Schinken
 | Salami       | Milch Bio
 deriving (Eq, Show)

data Menge = Stueck Int | Gramm  Int | Liter  Double
           deriving (Eq, Show)

type Preis = Maybe Int

preis :: Artikel -> Menge-> Preis
preis (Apfel a) (Stueck n) = Just (n* apreis a)
preis Eier (Stueck n)    = Just (n* 20)
preis (Kaese k)(Gramm g) = Just (round(fromIntegral g* 1000* kpreis k))
preis Schinken (Gramm g) = Just (div (g* 199) 100)
preis Salami (Gramm g)   = Just (div (g* 159) 100)
preis (Milch bio) (Liter l) = 
   Just (round (l* case bio of Bio -> 119; Konv -> 69))
preis _ _ = Nothing

cent :: Posten-> Int
cent (Posten a m) = fromMaybe 0 (preis a m) -- gibt keinen Laufzeitfehler!


-- Addition von Mengen
addiere :: Menge-> Menge-> Menge
addiere (Stueck i) (Stueck j)= Stueck (i+ j)
addiere (Gramm g) (Gramm h)  = Gramm (g+ h)
addiere (Liter l) (Liter m)  = Liter (l+ m)
addiere m n = error ("addiere: "++ show m++ " und "++ show n)

-- Posten:
data Posten = Posten Artikel Menge
              deriving (Eq, Show)

-- Lagerhaltung:
data Lager = Lager [Posten]
             deriving (Eq, Show)

leeresLager :: Lager
leeresLager = Lager []

suche :: Artikel-> Lager-> Maybe Menge
suche a (Lager ps) = 
   listToMaybe (map (\(Posten _ m)-> m) 
               (filter (\(Posten la _) -> la == a) ps))


einlagern :: Artikel-> Menge-> Lager-> Lager
einlagern a m (Lager ps) =
  let hinein a m [] = [Posten a m]
      hinein a m (Posten al ml:l)
         | a == al   = (Posten a (addiere m ml): l)
         | otherwise = (Posten al ml: hinein a m l)
  in case preis a m of 
       Nothing -> Lager ps
       _ -> Lager (hinein a m ps)

data Einkaufskorb = Ek [Posten]
                     deriving (Eq, Show)

leererWagen :: Einkaufskorb
leererWagen = Ek []

einkauf :: Artikel-> Menge-> Einkaufskorb-> Einkaufskorb
einkauf a m (Ek ps) 
  | isJust (preis a m) = Ek (Posten a m: ps)
  | otherwise          = Ek ps

kasse' :: Einkaufskorb-> Int
kasse' (Ek ps) = foldr (\p ps-> cent p+ ps) 0 ps

kasse :: Einkaufskorb-> Int
kasse (Ek ps) = sum (map cent ps)

kassenbon :: Einkaufskorb-> String
kassenbon ek@(Ek ps) = 
  "Bob's Aulde Grocery Shoppe\n\n"++
  "Artikel              Menge      Preis\n"++
  "-------------------------------------\n"++
  concatMap artikel ps ++
  "=====================================\n"++
  "Summe:"++ formatR 31 (showEuro (kasse ek))
 
artikel :: Posten-> String
artikel p@(Posten a m) = 
   formatL 20 (show a) ++
   formatR 7  (menge m) ++ 
   formatR 10 (showEuro (cent p)) ++ "\n"

menge :: Menge-> String
menge (Stueck n) = show n++ " St" 
menge (Gramm g)  = show g++ " g."
menge (Liter l)  = show l++ " l."

formatL :: Int-> String-> String
formatL n str = take n (str++ replicate n ' ')

formatR :: Int-> String-> String
formatR n str = 
  take n (replicate (n- length str) ' '++ str)

showEuro :: Int-> String
showEuro i = 
  show (div i 100) ++ "."++
  show (mod (div i 10) 10) ++
  show (mod i 10)++ " EU"

inventur :: Lager-> Int
inventur (Lager l) = sum (map cent l)

{- Examples: -}

w1= einkauf (Apfel Boskoop) (Stueck 3) leererWagen
w2= einkauf Schinken (Gramm 50) w1
w3= einkauf (Milch Bio) (Liter 1) w2
w4= einkauf Schinken (Gramm 50) w3

l1= einlagern (Apfel Boskoop) (Stueck 1) leeresLager
l2= einlagern Schinken (Gramm 50) l1
l3= einlagern (Milch Bio) (Liter 6) l2
l4= einlagern (Apfel Boskoop) (Stueck 4) l3
l5= einlagern (Milch Bio) (Liter 4) l4
l6= einlagern Schinken (Gramm 50) l5
