module Rev where

-- Direct linear recursion
rev1 :: [alpha]-> [alpha]
rev1 []     = []
rev1 (x:xs) = rev1 xs ++ [x]

-- Linear recursion, using foldr
rev2 :: [alpha]-> [alpha]
rev2 = foldr (\x xs-> xs++ [x]) []

-- Direct tail recursion
rev3 :: [alpha]-> [alpha]
rev3 xs = rev0 xs [] where
     rev0 []     ys = ys
     rev0 (x:xs) ys = rev0 xs (x:ys)

-- Tail recursion, using foldl
rev4 :: [alpha]-> [alpha]
rev4 = foldl (\xs x -> x: xs) []

-- Using foldl and flip (very much similar to above)
rev5 :: [alpha]-> [alpha]
rev5 = foldl (flip (:)) []
