module Primes where

import Data.List(genericLength)

-- Calculating primes with Eratosthenes

-- Sieve it (no filter)
{-- sieve_no_filter --}
sieve' :: [Integer]-> [Integer]
sieve' [] = []
sieve' (p:ps) = p: sieve' (filterPs ps) where
   filterPs (q: qs)
     | q `mod` p /= 0 = q: filterPs qs
     | otherwise      = filterPs qs              
{-- end --}

-- Sieve, with named helper function
{-- siev3 --}
siev3 :: [Integer]-> [Integer]
siev3 [] = []
siev3 (p:ps) = p: siev3 (filter (filterMod p) ps) where
  filterMod p q = q `mod` p /= 0
{-- end --}

{-- prim3s --}
prim3s :: [Integer]
prim3s = siev3 [2..]
{-- end --}


-- Sieve it (using filter)
{-- sieve --}
sieve :: [Integer]-> [Integer]
sieve [] = []
sieve (p:ps) = p: sieve (filter (\q-> q `mod` p /= 0) ps)
{-- end --}

-- All primes
{-- primes --}
primes :: [Integer]
primes = sieve [2..]
{-- end --}

-- The first n primes
{-- first_primes --}
n_primes :: Int-> [Integer]
n_primes n = take n primes 
{-- end --}

-- Number of primes smaller than n (prime counting function)
-- In the math literature, this is usually called pi but that clashes with the
--  predefined constant
{-- pi --}
pcf :: Integer-> Int
pcf n = length (takeWhile (\m-> m< n) primes)
{-- end --}
