module Palin where

import Data.Char (isAlphaNum, toLower)

{-- clean1 --}
clean :: String-> String
clean [] = []
clean (s:xs) | isAlphaNum s = toLower s : clean xs
             | otherwise    = clean xs
{-- end --}

{-- clean2 --}
clean' :: String-> String
clean' xs = map toLower (filter isAlphaNum xs)
{-- end --}

{-- clean3 --}
clean'' :: String-> String
clean'' = map toLower . filter isAlphaNum
{-- end --}

{-- palin --}
palin :: String-> Bool
palin s = reverse c == c where c = map toLower (filter isAlphaNum s)
{-- end --}
