#include <stdlib.h>
#include <stdio.h>

#include "list.h"

list cons(void *hd, list tl) 
{ list l;
  if ((l= (list)malloc(sizeof(struct list_t)))== NULL) {
    printf("Out of memory\n"); exit(-1);
  }
  l-> elem= hd; l-> next= tl;
  return l;
}

int length(list l)
{
  int i;
 
  for (i= 0; l!= NULL; l= l-> next) i++;

  return i;
}


/* Filter, rekursiv */
list filter(int f(void *x), list l)
{ if (l == NULL) {
    return NULL; 
  } else {
    list r;
    r= filter(f, l-> next);
    if (f(l-> elem)) {
      l->next= r;
      return l;
    }       
    else {
      free(l);
      return r;
} } }

/* Map, recursive -- creates a new list */
list map1(void *f(void *x), list l)
{
  return l== NULL ?
         NULL : cons(f(l-> elem), map1(f, l-> next));
}    

/* Map, iterative -- changes list in-place */
list map2(void *f(void *x), list l)
{
  list c;
  for (c= l; c!= NULL; c= c-> next) {
    c-> elem= f(c-> elem); }
  return l;
}   

/* Note that this has a memory leak-- the old c-> elem gets lost.
 * Fixing that makes it verbose: 
 */
list map(void *f(void *x), list l)
{
  list c; void *d;  
  for (c= l; c!= NULL; c= c-> next) {
    d= c-> elem;
    c-> elem= f(c-> elem);
    free(d);
    }
  return l;
}   


/* mapM_ -- map with side effects only */
void mapM_(void f(void *x), list l)
{
  list c;
  for (c= l; c!= NULL; c= c-> next) {
    f(c-> elem);
    }
}
