module Examples where

import Prelude hiding (map, filter, (.), flip, foldr, foldl, sum, concat, length, and, all, const, elem)
import Data.Char(toLower, toUpper, isAlpha, isDigit)

toL :: String-> String
toL []     = []
toL (c:cs) = toLower c : toL cs

toU :: String-> String
toU []     = []
toU (c:cs) = toUpper c : toU cs    

map :: (alpha-> beta)-> [alpha]-> [beta]
map f []     = []
map f (c:cs) = f c : map f cs

toL' cs = map toLower cs
toU' cs = map toUpper cs

filter :: (alpha-> Bool)-> [alpha]-> [alpha]
filter p []   = []
filter p (x:xs) 
  | p x       = x: filter p xs
  | otherwise = filter p xs

digits :: String-> String
digits = filter isDigit    


(.) :: (beta-> gamma) -> (alpha-> beta)-> alpha-> gamma
(f . g) x = f (g x)

(>..>) :: (alpha-> beta)-> (beta-> gamma)-> alpha-> gamma
(f >..> g) x = g (f x)

flip :: (alpha-> beta-> gamma)-> beta-> alpha-> gamma
flip f b a = f a b

(>.>) :: (alpha-> beta)-> (beta-> gamma)-> alpha-> gamma
(>.>) = flip (.)

foldr :: (alpha-> beta-> beta)-> beta-> [alpha]-> beta
foldr f e []     = e
foldr f e (x:xs) = f x (foldr f e xs)

sum :: [Int]-> Int
sum xs = foldr (+) 0 xs

concat :: [[a]]-> [a]
concat xs = foldr (++) [] xs

length :: [a]-> Int
length xs = foldr (\x n-> n+ 1) 0 xs    

and :: [Bool] -> Bool
and xs = foldr (&&) True xs

all :: (alpha-> Bool)-> [alpha] -> Bool
all p xs = and (map p xs)

foldl :: (alpha -> beta -> alpha) -> alpha -> [beta] -> alpha
foldl f a [] = a
foldl f a (x:xs) = foldl f (f a x) xs

const :: alpha-> beta-> alpha
const c _ = c

mystery :: [alpha]-> Int
mystery xs = sum (map (const 1) xs)

elem :: (Eq alpha)=> alpha-> [alpha]-> Bool
elem x xs = not (null (filter (\y-> x == y) xs))
