module Maybe where

import Prelude hiding (Maybe, Just, Nothing, fromJust, fromMaybe, listToMaybe, maybeToList)


data Maybe alpha = Nothing | Just alpha

fromJust    :: Maybe alpha -> alpha     -- partiell
fromMaybe   :: alpha-> Maybe alpha-> alpha
listToMaybe :: [alpha]-> Maybe alpha    -- totale Variante von \mcode{head}
maybeToList :: Maybe alpha-> [alpha]    -- rechtsinvers zu \mcode{listToMaybe}

fromJust (Just a) = a

fromMaybe d (Just a) = a
fromMaybe d Nothing  = d

listToMaybe []    = Nothing
listToMaybe (x:_) = Just x

maybeToList Nothing  = []
maybeToList (Just x) = [x]
