module Strictness where

import Shoppe

f :: Preis -> Int
f p = case p of Cent i -> i; Ungueltig -> 0

g :: Preis-> Int
g p = case p of Cent i -> 99; Ungueltig -> 0

-- This shows how undefined values are passed along:
add :: Preis-> Preis-> Preis
add (Cent i) (Cent j) = Cent (i+ j)
add _ _ = Ungueltig

{- Try this:

f Ungueltig
f (Cent undefined)
g Ungueltig
g (Cent undefined)

-- This shows that arguments are evaluated only as far as needed
f (Cent (g (Cent undefined)))

-- This shows that order matters:
add undefined Ungueltig
add Ungueltig undefined

-- In the second/third case, the undefined value gets passed along 
-- and is then thrown away:
f (add (Cent undefined) (Cent 1))
g (add (Cent undefined) (Cent 1))
f (add (Cent undefined) Ungueltig)

-}
