module Shoppe where

data Apfelsorte = Boskoop | CoxOrange | GrannySmith 
                  deriving (Eq, Show)

apreis :: Apfelsorte -> Int
apreis Boskoop = 55
apreis CoxOrange = 60
apreis GrannySmith = 50

data Kaesesorte = Gouda | Appenzeller  
                  deriving (Eq, Show)

kpreis :: Kaesesorte -> Int
kpreis Gouda = 1450
kpreis Appenzeller = 2270

data Bio = Bio | Chemie
           deriving (Eq, Show)

data Artikel = 
    Apfel Apfelsorte    | Eier        | Kaese Kaesesorte
  | Schinken            | Salami      | Milch Bio
  deriving (Eq, Show)


data Menge = Stueck Int | Gramm Int | Liter Double
             deriving (Eq, Show)

data Preis = Cent Int | Ungueltig 
             deriving (Eq, Show)

preis :: Artikel -> Menge-> Preis
preis (Apfel a) (Stueck n)  = Cent (n* apreis a)
preis Eier (Stueck n)       = Cent (n* 20)
preis (Kaese k)(Gramm g)    = Cent (div (g* kpreis k) 1000)
preis Schinken (Gramm g)    = Cent (div (g* 199) 100)
preis Salami (Gramm g)      = Cent (div (g* 159) 100)
preis (Milch bio) (Liter l) =
     Cent (round (l* case bio of Bio -> 119; Chemie -> 69))
preis _ _ = Ungueltig

-- Addition von Mengen
addiere :: Menge-> Menge-> Menge
addiere (Stueck i) (Stueck j)= Stueck (i+ j)
addiere (Gramm g) (Gramm h)  = Gramm (g+ h)
addiere (Liter l) (Liter m)  = Liter (l+ m)
addiere m n = error ("addiere: "++ show m++ " und "++ show n)

-- Lagerhaltung (Lecture 03):
data Lager = LeeresLager
           | Lager Artikel Menge Lager
           deriving Show

data Resultat = Gefunden Menge | NichtGefunden  
                deriving Show

suche :: Artikel-> Lager-> Resultat
suche art (Lager lart m l) 
  | art == lart = Gefunden m
  | otherwise   = suche art l
suche art LeeresLager  = NichtGefunden

einlagern :: Artikel-> Menge-> Lager-> Lager
einlagern a m l = 
  let einlagern' a m LeeresLager = Lager a m LeeresLager
      einlagern' a m (Lager al ml l) 
         | a == al   = Lager a (addiere m ml) l
         | otherwise = Lager al ml (einlagern' a m l) 
  in case preis a m of 
       Ungueltig -> l
       _ -> einlagern' a m l

data Einkaufskorb = LeererKorb
                   | Einkauf Artikel Menge Einkaufskorb
                   deriving Show


einkauf :: Artikel-> Menge-> Einkaufskorb-> Einkaufskorb
einkauf a m e = 
  case preis a m of
    Ungueltig -> e
    _ -> Einkauf a m e

kasse :: Einkaufskorb-> Int
kasse LeererKorb = 0
kasse (Einkauf a m e) = cent a m+ kasse e

cent :: Artikel-> Menge-> Int
cent a m = case preis a m of Cent c-> c

kassenbon :: Einkaufskorb-> String
kassenbon ew = 
  "\n** Bob's Aulde-Time Grocery Shoppe **\n\n"++
  "Artikel              Menge      Preis\n"++
  "-------------------------------------\n"++
  artikel ew ++
  "=====================================\n"++
  "Summe:"++ formatR 31 (showEuro (kasse ew)) ++ "\n"
 
artikel :: Einkaufskorb-> String
artikel LeererKorb = ""
artikel (Einkauf a m e) = 
   formatL 20 (show a) ++
   formatR 7  (menge m) ++ 
   formatR 10 (showEuro (cent a m)) ++ "\n"++ artikel e

menge :: Menge-> String
menge (Stueck n) = show n ++ " St" 
menge (Gramm g)  = show g ++ " g."
menge (Liter l)  = show l ++ " l."

formatL :: Int-> String-> String
formatL n str = 
  if length str < n then formatL n (str ++ " ") else str

formatR :: Int-> String-> String
formatR n str = 
  if length str < n then formatR n (' ': str) else str

showEuro :: Int-> String
showEuro i = 
  show (div i 100) ++ "."++
  show (mod (div i 10) 10) ++
  show (mod i 10)++ " EU"

inventur :: Lager-> Int
inventur LeeresLager = 0
inventur (Lager a m l) = cent a m+ inventur l

{- Examples: -}

k1= einkauf (Apfel Boskoop) (Stueck 3) LeererKorb
k2= einkauf Schinken (Gramm 50) k1
k3= einkauf (Milch Bio) (Liter 1) k2
k4= einkauf Schinken (Gramm 50) k3
k5= einkauf (Kaese Appenzeller) (Gramm 378) k4

l1= einlagern (Apfel Boskoop) (Stueck 1) LeeresLager
l2= einlagern Schinken (Gramm 50) l1
l3= einlagern (Milch Bio) (Liter 6) l2
l4= einlagern (Apfel Boskoop) (Stueck 4) l3
l5= einlagern (Milch Bio) (Liter 4) l4
l6= einlagern Schinken (Gramm 50) l5
