--
-- "Zeichenketten selbstgemacht"
-- 
module MyString where

-- Auf String vordefinierte Funktionen verstecken:
import Prelude hiding (length,(++),repeat, take, drop)

{-- mystring --}
data MyString = Empty 
              | Char :+ MyString 
{-- end --}
              deriving (Show, Eq)

-- Nicer output
string :: MyString-> String
string Empty = ""
string (c :+ s) = c: string s

-- Reading strings
myString :: String-> MyString
myString s =
  if null s then Empty else head s :+ myString (tail s)

-- Verkettung zweier Zeichenketten
{-- concat --}
(++) :: MyString-> MyString-> MyString
Empty ++ t  = t
(c :+ s) ++ t = c :+ (s++ t)
{-- end --}

-- Laenge einer Zeichenkette
{-- length --}
length :: MyString-> Int
length Empty    = 0
length (c :+ s) = 1+ length s      
{-- end --}

-- Zeichenkette umkehren
{-- reverse --}
rev :: MyString-> MyString
rev Empty    = Empty
rev (c :+ t) = rev t ++ (c :+ Empty)
{-- end --}

-- Nochmal Palindrom
palin :: MyString-> Bool
palin s = s == rev s

-- Eine Zeichenkette n-mal wiederholen
repeat :: Int-> MyString-> MyString
repeat n s = if n == 0 then Empty
             else s ++ repeat (n-1) s


-- Die ersten n Zeichen der Zeichenkette
-- Voraussetzung: n >= 0
take :: Int-> MyString-> MyString
take n Empty = Empty
take n (c :+ s) | n == 0 = Empty
                | otherwise = c :+ take (n-1) s

-- Die letzten n Zeichen der Zeichenkette
-- Voraussetzung: n >= 0
drop :: Int-> MyString-> MyString
drop n Empty  = Empty
drop n (c :+ s) | n == 0  = c :+ s
                | otherwise = drop (n- 1) s
