module Bool where

-- Booleans, selbstgemacht

-- "Verstecken" der vordefinierten Booleans:
import Prelude hiding (Bool(..), not, (&&), (||), and)

data Bool= False | True
           deriving Show

not  :: Bool-> Bool         -- Negation
(&&) :: Bool-> Bool-> Bool  -- Konjunktion
(||) :: Bool-> Bool-> Bool  -- Disjunktion

not b = case b of  True -> False
                   False -> True

a && b = case a of False -> False
                   True -> b
                   
a || b = case a of True -> True
                   False -> b

-- Exclusive or
-- Note xor is strict in both arguments
xor :: Bool-> Bool-> Bool
xor x y = (x || y) && (not (x && y))

-- Diese Konjunktion ist strikt im zweiten Argument:
and :: Bool-> Bool-> Bool
and False True  = False
and False False = False
and True  True  = True
and True  False = False

{-
-- Try this script:
and False undefined
False && undefined
-}
