module Strings where

-- Diese Zeile versteckt die vordefinierten Funktionen
import Prelude hiding (repeat, last, init, (++), length)
import Data.Char (isAlphaNum, toLower)

-- Zeichenketten verketten:
(++) :: String-> String-> String
xs ++ ys
  | null xs   = ys
  | otherwise = head xs : (tail xs ++ ys)        

-- Länge einer Zeichenkette
length :: String-> Int
length s
  | null s    = 0
  | otherwise = 1+ length (tail s)

-- Einen String n-mal wiederholen
repeat :: Int-> String-> String
repeat n s = if n == 0 then ""
             else s ++ repeat (n-1) s

-- Strings konstruieren: Ein Quadrat aus Zeichen
quadrat :: Int-> Char-> String
quadrat n c = repeat n (repeat n (c: "") ++ "\n")

-- Letztes Zeichen, mit Fehlermeldung
last :: String-> Char
last s
  | null s = error "last: empty string"
  | null (tail s) = head s
  | otherwise     = last (tail s)

-- Anfang des Strings, ohne Fehler (total definierte Funktion)
init1 :: String-> String
init1 s 
  | null s = s
  | null (tail s) = ""
  | otherwise     = head s : init1 (tail s)

-- Anfang des Strings, Fehler für leeren String (partiell definierte Funktion)
init :: String-> String
init s
  | null s = error "init: empty string"      -- nicht s
  | null (tail s) = ""
  | otherwise     = head s : init (tail s)
  
-- Endrekursive Version
init' :: String-> String
init' s = init' s "" where
  init' s r | null s = error "..."
            | null (tail s) = r
            | otherwise = init' (tail s) (r ++ (head s: ""))

-- Es gilt: head s : tail s == s == init s ++ (last s: "")

-- Palindrom: Vorwärts und rückwärts gleich
palin1 :: String-> Bool
palin1 s
  | length s <= 1    = True
  | head s == last s = palin1 (init (tail s))
  | otherwise        = False

palin3 :: String-> Bool
palin3 s = length s <= 1 || head s == last s && palin3 (init (tail s))
  -- Terminiert nur wegen || nicht-strikt im zweiten Argument
  

-- Damit auch der Klassiker "A man, a plan,  a canal: Panama!" funktioniert.
palin2 :: String-> Bool
palin2 s = palin1 (clean s)

clean :: String-> String
clean s
  | null s = ""
  | isAlphaNum (head s) = toLower (head s) : clean (tail s)
  | otherwise = clean (tail s)

palin1' :: String-> Bool
palin1' s = if length s <= 1 then True
            else if head s == last s then palin1' (init (tail s))
                                     else False

