
-- Erste Variante
count1 :: Char-> String-> Int
count1 c s =
  if null s then 0
  else if head s== c then 1+ count1 c (tail s)
                     else count1 c (tail s)

-- Zweite Variante: lesbarer, mit guards
count2 :: Char-> String-> Int
count2 c s
  | null s = 0
  | head s == c = 1+ count2 c (tail s)
  | otherwise   = count2 c (tail s)

-- Dritte Variante: endrekursiv
count3 :: Char-> String-> Int
count3 c s = count3' c s 0
count3' :: Char-> String-> Int-> Int
count3' c s r =
  if null s then r
  else count3' c (tail s) (if head s == c then 1+r else r) 
  
-- Vierte Variante: endrekursiv, mit lokaler Definition
count4 :: Char-> String-> Int
count4 c s = count4' s 0 where
  count4' s r =
    if null s then r
    else count4' (tail s) (if head s == c then 1+r else r) 
