module Main where

import Text.Printf
import qualified Data.Map as Map

import Test.Tasty
import Test.Tasty.HUnit

import Diagonal
import Diamond
import NTree
import Frequency

main = defaultMain $ testGroup "Programmieraufgaben Wiederholungsklausur" [
       exercise1
     , exercise2
     , exercise3
     , exercise4
     ]

exercise :: Int-> String -> Int -> [TestTree] -> TestTree
exercise i nm pts = testGroup (printf "%d %-40s (%d Punkte)" i nm pts)

exercise1 = exercise 1 "Diagonalen" 5 $ [
  testCase "diag [[1], [10, 20, 30], [100, 200, 300]]" $
    diag [[1], [10, 20, 30], [100, 200, 300]] @?= [1, 20, 300],
  testCase "diag [\"abc\", \"def\", \"ghi\", \"jklmn\", \"o\", \"pqrstu\"]" $
    diag ["abc", "def", "ghi", "jklmn", "o", "pqrstu"] @?= "aeim",
  testCase "diag (repeat [1..])" $
    take 10 (diag (let i= 1:2:3:4:5:6:7:8:9:10:undefined 
                   in  i:i:i:i:i:i:i:i:i:i:undefined)) @?= [1.. 10]
  ]


exercise2 = exercise 2 "Rauten" 5 $ [
  testCase "diamond 'x' 1" $
    diamond 'x' 1 @?= "x\n",
  testCase "diamond '*' 5" $
    diamond '*' 5 @?= "    *\n   ***\n  *****\n *******\n*********\n *******\n  *****\n   ***\n    *\n"
  ]


tree1 = NT 4 []
tree2 = NT 3 [tree1, tree1]
tree3 = NT 2 [tree1, tree2, tree1]
tree4 = NT 1 [tree1, tree3, tree2]

exercise3 = exercise 3 "Variadische Bäume" 4 [
  testCase "height tree1" $ height tree1 @?= 1,
  testCase "height tree2" $ height tree2 @?= 2,
  testCase "height tree3" $ height tree3 @?= 3,
  testCase "height tree4" $ height tree4 @?= 4,
  testCase "balanced tree1" $ balanced tree1 @?= True, 
  testCase "balanced tree2" $ balanced tree2 @?= True,
  testCase "balanced tree3" $ balanced tree3 @?= True, 
  testCase "balanced tree4" $ balanced tree4 @?= False
  ]

sortedSnd :: Ord b=> [(a, b)]-> Bool
sortedSnd [] = True
sortedSnd [_] = True
sortedSnd ((_, i):(xs@((_, j):_))) = i >= j && sortedSnd xs

str1 = "`abc123AB!ax."
res1 = [('a',3),('b',2),('x',1),('c',1)]
str2 = "Straßenbahnlinie 6?"
res2 = [('n',3),('i',2),('e',2),('a',2),('ß',1),('t',1),('s',1),('r',1),('l',1),('h',1),('b',1)]

checkRes str res =
  testCase ("frequency \""++ str++ "\"") $
    Map.fromList (frequency str) == Map.fromList res @? printf "Expected %s, got %s" (show res) (show (frequency str)) where 

exercise4 = exercise 4 "Frequenzen" 6 $ [
  testCase "frequency []" $ frequency [] @?= [],
  checkRes str1 res1,
  testCase ("frequency \""++ str1++ "\" sorted") $
    sortedSnd (frequency str1) @? "Result list not sorted",
  checkRes str2 res2,
  testCase ("frequency \""++ str2++ "\" sorted") $
    sortedSnd (frequency str2) @? "Result list not sorted"
  ]

