module Main where

import Text.Printf

import Test.Tasty
import Test.Tasty.HUnit

import Histogram
import DropEvery

main = defaultMain $ testGroup "Programmieraufgaben Übungsklausur" [
    exercise1,
    exercise2
    ]

exercise :: Int-> String -> Int -> [TestTree] -> TestTree
exercise i nm pts = testGroup (printf "%d %-40s (%d Punkte)" i nm pts)

exercise1 = exercise 1 "Histogram" 2 $ [
  testCase "histogram '*' [3, 5, 2]" $
     histogram '*' [3, 5, 2] @?= "***\n*****\n**\n",
  testCase "histogram 'X' [1, 5, 1, 3]" $ 
     histogram 'X' [1,5,1,3] @?= "X\nXXXXX\nX\nXXX\n"
  ]

exercise2 = exercise 2 "Listen sieben" 2 $ [
  testCase "dropEvery 3 \"abcdefg\"" $
     dropEvery 3 "abcdefg" @?= "abdeg",
  testCase "dropEvery 5 [0..14]" $
     dropEvery 5 [0..14] @?= [0,1,2,3,5,6,7,8,10,11,12,13]
  ]


  

            
