{-# LANGUAGE ImplicitParams #-}
module Main where

import Text.Printf

import Test.Tasty
import Test.Tasty.HUnit
import Test.HUnit.Approx

import Triangle
import Geometry
import Histogram
import Unzip

main = defaultMain $ testGroup "Programmieraufgaben Übungsklausur" [
      exercise1
    , exercise2
    , exercise3
    , exercise4
    , exercise5
    ]

exercise :: Int-> String -> Int -> [TestTree] -> TestTree
exercise i nm pts = testGroup (printf "%d %-40s (%d Punkte)" i nm pts)

exercise1 = exercise 1 "Dreieck" 4 $ [
  testCase "triangle [\"a\", \"xy\", \"123\"]" $
     triangle ["a", "xy", "123"]  @?= True,
  testCase "triangle [[1], [2, 3], [3]]" $ 
     triangle [[1], [2, 3], [3]] @?= False
  ]

exercise2 = let ?epsilon = 0.0001 in 
  exercise 2 "Geometrie" 6 $ [
  testCase "area (Circle 3.7)" $ 
     area (Circle 3.7) @?~ 43.008403427644275,
  testCase "area (Square 2)" $
     area (Square 2) @?~ 4,
  testCase "areaSum [Square 1, Rectangle 3 4]" $
     areaSum [Square 1, Rectangle 3 4] @?~ 13,
  testCase "Square 2 == Rectangle 2 2" $
     (Square 2 == Rectangle 2 2) @?= True,
  testCase "Square 2.2 == Rectangle 5.7 8.2" $
     (Square 2.2 == Rectangle 5.7 8.2) @?= False     
  ]

exercise3 = exercise 3 "Histogram" 5 $ [
  testCase "histogram '*' [3,5,2]" $
    histogram '*' [3,5,2] @?= " * \n * \n** \n***\n***\n",
  testCase "histogram 'X' [1,5,1,3]" $
    histogram 'X' [1,5,1,3] @?= " X  \n X  \n X X\n X X\nXXXX\n"
  ]

exercise4 = exercise 4 "Unzip" 5 $ [
  testCase "unzipN 5 \"abcdefghijklmno\"" $
    unzipN 5 "abcdefghijklmno" @=? ["afk","bgl","chm","din","ejo"],
  testCase "unzipN 3 [1..10]" $
    unzipN 3 [1..10] @=?  [[1,4,7,10],[2,5,8],[3,6,9]]
  ]

exercise5 = exercise 5 "Infinite lists" 2 $ [
  testCase "triangle [[1], [2, 3], [1..]]" $ 
     triangle [[1], [2, 3], 1:2:3:4:5:undefined ] @?= False,
  testCase "unzipN 3 [1..]" $
    map (take 2) (unzipN 3 $ 1:2:3:4:5:6:7:8:undefined) @=? [[1,4],[2,5],[3,6]] 
  ]
  
