module Shop.Lager(
    Lager
  , Posten(..)
  , leeresLager
  , einlagern
  , verfuegbar
  , entnehmen
  , suche
  , bestand
  ) where

import Data.Maybe(listToMaybe, fromJust)
import qualified Data.Map.Lazy as M

import Shop.Artikel

-- Lagerhaltung:
data Lager = Lager (M.Map Artikel Int)
             deriving Show

leeresLager :: Lager
leeresLager = Lager (M.empty)

einlagern :: Posten-> Lager-> Lager
einlagern p = lagern (artikel p) (menge p) 

entnehmen :: Posten-> Lager-> Lager
entnehmen p lg
  | verfuegbar (artikel p) lg >= menge p = lagern (artikel p) (- (menge p)) lg
  | otherwise                            = lg

lagern :: Artikel-> Int-> Lager-> Lager
lagern a m (Lager l) = case M.lookup a l of
  Just q  -> Lager (M.insert a (m+ q) l)
  Nothing -> Lager (M.insert a m l)

suche :: Artikel-> Lager-> Maybe Int
suche a (Lager l) =  M.lookup a l

verfuegbar :: Artikel-> Lager-> Int
verfuegbar a (Lager l) = M.findWithDefault 0 a l

bestand :: Lager-> [Posten]
bestand (Lager m) = map (uncurry Posten) $ M.toList m
