module Shop.Artikel where

import Data.Maybe(fromJust)

-- Modellierung der Artikel.
data Apfelsorte = Boskoop | CoxOrange | GrannySmith 
             deriving (Eq, Ord, Show)

apreis :: Apfelsorte -> Int
apreis Boskoop = 55
apreis CoxOrange = 60
apreis GrannySmith = 50

data Kaesesorte = Gouda | Appenzeller  
             deriving (Eq, Ord, Show)

kpreis :: Kaesesorte -> Int
kpreis Gouda = 1450
kpreis Appenzeller = 2270

data Bio = Bio | Konv
           deriving (Eq, Ord, Show)

data Artikel = 
   Apfel Apfelsorte  | Eier
 | Kaese Kaesesorte  | Schinken
 | Salami       | Milch Bio
 deriving (Eq, Ord, Show)

-- Artikel sind aufzhlbar
instance Enum Artikel where
  fromEnum (Apfel Boskoop) = 0
  fromEnum (Apfel CoxOrange) = 1
  fromEnum (Apfel GrannySmith) = 2
  fromEnum Eier = 3
  fromEnum (Kaese Gouda) = 4
  fromEnum (Kaese Appenzeller) = 5
  fromEnum Schinken = 6
  fromEnum Salami = 7
  fromEnum (Milch Bio) = 8
  fromEnum (Milch Konv) = 9
  toEnum 0 = Apfel Boskoop
  toEnum 1 = Apfel CoxOrange
  toEnum 2 = Apfel GrannySmith
  toEnum 3 = Eier
  toEnum 4 = Kaese Gouda
  toEnum 5 = Kaese Appenzeller
  toEnum 6 = Schinken
  toEnum 7 = Salami
  toEnum 8 = Milch Bio
  toEnum 9 = Milch Konv

instance Bounded Artikel where
  minBound = Apfel Boskoop
  maxBound = Milch Konv

alleArtikel :: [Artikel]
alleArtikel = [minBound .. maxBound]

-- Ein Artikel in einer bestimmten Anzahl ist ein Posten:
data Posten = Posten { artikel :: Artikel
                     , menge   :: Int
                     }

preis :: Posten-> Int
preis (Posten (Apfel a) n) = n* apreis a
preis (Posten Eier n)      = n* 20
preis (Posten (Kaese k) g) = g* kpreis k `div` 1000
preis (Posten Schinken g)  = g* 199 `div` 100
preis (Posten Salami g)    = g* 159 `div` 100
preis (Posten (Milch b) l) = l* case b of Bio -> 119; Konv -> 69

einheitsmenge :: Artikel-> Int
einheitsmenge (Apfel _) = 1
einheitsmenge Eier      = 1
einheitsmenge (Kaese _) = 1000
einheitsmenge Schinken  = 100
einheitsmenge Salami    = 100
einheitsmenge (Milch _) = 1 

einheitspreis :: Artikel-> Int
einheitspreis a = preis (Posten a (einheitsmenge a))

-- Muesste eigentlich "Mengeneinheiten" heien
data Menge = Stueck | Gramm | Liter
           deriving (Eq, Ord, Show)

mengeneinheit :: Artikel-> Menge
mengeneinheit (Apfel _) = Stueck
mengeneinheit Eier      = Stueck
mengeneinheit (Kaese _) = Gramm
mengeneinheit Schinken  = Gramm
mengeneinheit Salami    = Gramm
mengeneinheit (Milch _) = Liter

-- Unterhalb dieser Grenze gilt ein Artikel als "knapp"
mindestvorrat :: Artikel-> Int
mindestvorrat (Apfel _) = 5
mindestvorrat Eier      = 5
mindestvorrat (Kaese _) = 500
mindestvorrat Schinken  = 300
mindestvorrat Salami    = 500
mindestvorrat (Milch _) = 5
