{-# LANGUAGE OverloadedStrings #-}
module Main where

import Control.Concurrent.MVar
import Control.Monad.IO.Class (liftIO)
import Text.Blaze.Html hiding (text)
import Text.Blaze.Html.Renderer.Text
import Web.Scotty

import qualified Shop.Backend as Shop
import Controller
import View

main :: IO ()
main = do 
  sv <- newMVar $ Shop.initial
  scotty 3000 $ do
    controller sv
    -- serve static files 
    get "/static/css/bob.css" $ do
      setHeader "Content-Type" "text/css" 
      file "static/css/bob.css"
{-      
    get "/static/img/logo.png" $ do
      setHeader "Content-Type" "image/png" 
      file "static/img/logo.png"
    get "/static/img/smile.jpg" $ do
      setHeader "Content-Type" "image/jpg" 
      file "static/img/smile.jpg"
    get "/static/img/coffee.jpg" $ do
      setHeader "Content-Type" "image/jpg" 
      file "static/img/coffee.jpg"
    get "/static/img/cafe.jpg" $ do
      setHeader "Content-Type" "image/jpg" 
      file "static/img/cafe.jpg"
-}
