{-# LANGUAGE OverloadedStrings #-}
module Main where

import Control.Monad
import Data.Monoid
import Data.Maybe
import Data.Text.Read
import qualified Data.Text as T
import qualified Data.Text.Lazy as TL

import Text.Blaze.Html.Renderer.Text
import Text.Blaze.Html5 as H hiding (html, main)
import Text.Blaze.Html5.Attributes as A

import Web.Scotty
import Web.Scotty.Cookie


main :: IO ()
main = scotty 3000 $
  get "/" $ do
    html $ renderHtml $ helloPage

helloPage :: Html
helloPage =
  docTypeHtml $ do
     H.head $ do
         H.title "Hello World"
     H.body $ do
         H.h1 "Hello World!" 
