module Ex where

import Data.Char (isUpper, toLower)
import SimpleStateMonad

-- Example using a very simple state
type WithCounter alpha = State Int alpha


-- This function is like toLower, but also counts the number of upper-case
-- characters converted to lower.
cntToLower :: String-> (String, Int)
cntToLower s = run (cntToL s) 0

-- Main function : we can now use monad syntax!
cntToL :: String-> WithCounter String
cntToL [] = return ""
cntToL (x:xs)
  | isUpper x =  do ys<- cntToL xs 
                    set (+1)
                    return (toLower x: ys)
  | otherwise =  do { ys<- cntToL xs; return (x: ys) }
