module SimpleStateMonad(
   State
 , run
 , get
 , set
 ) where

-- The simple state transformer as a monad

-- Type representing a state transforming function
-- We need to wrap this in a datatype to be able to make it into an instance
data State sigma alpha = St { run' :: sigma-> (alpha, sigma) }

-- Transforming functions: Functor instance
instance Functor (State sigma) where
  fmap f g = St $ \s-> (\(a, s1)-> (f a, s1)) (run g s)

-- Applicate instance
instance Applicative (State sigma) where
  pure a  = St $ \s-> (a, s)
  p <*> q = St $ \s-> let (f, s') = run p s
                          (a, s'') = run q s'
                      in  (f a, s'')

-- Composition and lifting: Monad instance
instance Monad (State sigma) where
  f >>= g = St $ \s -> let (a, s')= run f s
                       in  run (g a) s'
  return a = St $ \s-> (a, s)


-- Basic operations

-- Reading the state
get :: (sigma-> alpha)-> State sigma alpha
get f = St $ \s-> (f s, s)

-- Changing the state
set :: (sigma-> sigma)-> State sigma ()
set g = St $ \s-> ((), g s)

-- Running
run :: State sigma alpha-> sigma-> alpha
run = fst . run'
