module SimpleState where

import Prelude hiding (curry, uncurry, map)
import Data.Char (isUpper, toLower)

curry   :: ((alpha, beta) -> gamma)-> alpha-> beta-> gamma
uncurry :: (alpha-> beta-> gamma)-> (alpha, beta) -> gamma

curry f a b     = f (a, b)
uncurry f (a, b)= f a b    

-- A very simple ``state transformer''

-- Type representing a state transforming function
type State sigma alpha = sigma-> (alpha, sigma)

-- Composition of two state transformers
comp :: State sigma alpha-> (alpha-> State sigma beta)-> State sigma beta
comp f g = uncurry g . f

-- Lifting: the trivial state transformer
lift :: alpha-> State sigma alpha
lift = curry id

-- Transforming functions
map :: (alpha-> beta)-> State sigma alpha-> State sigma beta
map f g = (\(a, s)-> (f a, s)) . g

-- Basic operations

-- Reading the state
get :: (sigma-> alpha)-> State sigma alpha
get f s = (f s, s)

-- Setting the state
set :: (sigma-> sigma)-> State sigma ()
set g s = ((), g s)

-- Example using a very simple state
type WithCounter alpha = State Int alpha


-- This function is like toLower, but also counts the number of upper-case
-- characters converted to lower.
cntToLower :: String-> (String, Int)
cntToLower s = cntToL s 0

-- Main function 
cntToL :: String-> WithCounter String
cntToL [] = lift ""
cntToL (x:xs)
  | isUpper x =  cntToL xs `comp`
                 \ys-> set (+1) `comp`
                 \()-> lift (toLower x: ys)
  | otherwise = cntToL xs `comp` \ys-> lift (x: ys)
