module ResMonad(
    Res
  , run
  , get
  , fail
  , join
  ) where


import Prelude hiding (fail)

-- "exceptions"
type Exn alpha = Either String alpha

-- The result monad: a combination of reader monad, list monad and either monad.
data Res sigma alpha = Res { run :: sigma-> [Exn alpha] }

{-- functor --}
instance Functor (Res sigma) where
  fmap f (Res g) = Res $ fmap (fmap f). g 
{-- end --}

instance Applicative (Res sigma) where
  pure a = Res (const [Right a])
  Res f <*> Res a = Res $ \s-> do h<-f s; i<- a s; return $ h <*> i

{-- monad --}
instance Monad (Res sigma) where
  return a = Res (const [Right a])
  Res f >>= g = Res $ \s-> do ma<- f s
                              case ma of
                                Right a-> run (g a) s
                                Left e -> return (Left e)
{-- end --}

-- Elementary operations:

{-- get --}
get :: (sigma-> Exn alpha)-> Res sigma alpha
get f = Res $ \s-> [f s]
{-- end --}

{-- fail --}
fail :: String-> Res sigma alpha
fail msg = Res $ const [Left msg]
{-- end --}

{-- join --}
join :: alpha-> alpha-> Res sigma alpha
join a b = Res $ \s-> [Right a, Right b]
{-- end --}
