module ReaderMonad where

data Reader sigma alpha = R {run :: sigma-> alpha}

instance Functor (Reader sigma) where
  fmap f (R g) = R (f. g)

instance Applicative (Reader sigma) where
  pure a = R (const a)
  R g <*> R f = R $ \s-> g s (f s)

instance Monad (Reader sigma) where
  return a = R (const a)
  R f >>= g = R $ \s-> run (g (f s)) s


--Elementary operations: reading the state
get :: (sigma-> alpha)-> Reader sigma alpha
get f = R $ \s-> f s
-- equivalent to get = R 

