module Perms where

-- Ohne Monaden-Notation
ins' :: alpha-> [alpha]-> [[alpha]]
ins' x [] = [[x]]
ins' x (y:ys) = [x:y:ys] ++ [ y:is | is<- ins' x ys ]

perms' :: [alpha]-> [[alpha]]
perms' [] = [[]]
perms' (x:xs) = [ is | ps <- perms' xs, is <- ins' x ps ]

-- In Monaden-Notation:
ins :: alpha-> [alpha]-> [[alpha]]
ins x [] = return [x]
ins x (y:ys) = [x:y:ys] ++ do
  is <- ins x ys
  return $ y:is

perms :: [alpha]-> [[alpha]]
perms [] = return []
perms (x:xs) = do
  ps <- perms xs
  is <- ins x ps
  return is
