module MaybeMonad where

-- Maybe and Either Monad Instances

import Prelude hiding (Maybe, Just, Nothing, Either, Left, Right)

data Maybe alpha = Just alpha | Nothing

instance Functor Maybe where
  fmap f (Just a) = Just (f a)
  fmap f Nothing  = Nothing

instance Applicative Maybe where
  pure a = Just a
  Just f <*> Just b = Just (f b)
  _ <*> _ = Nothing

instance Monad Maybe where
  Just a >>= g  = g a
  Nothing >>= g = Nothing
  return = Just

data Either epsilon alpha = Left epsilon | Right alpha 

instance Functor (Either epsilon) where
  fmap f (Right b) = Right (f b)
  fmap f (Left  a) = Left  a

instance Applicative (Either epsilon) where
  pure    = Right 
  Right f <*> Right b = Right (f b)
  _ <*> Left b = Left b

instance Monad (Either epsilon) where
  Right b >>= g = g b
  Left a  >>= _ = Left a
  return = Right

throw :: epsilon-> Either epsilon alpha
throw e = Left e

catch :: Either epsilon alpha -> (epsilon-> alpha)-> alpha
catch f handle = case f of
  Right a -> a
  Left  e -> handle e
