module ListMonad where

-- List Monad Instance

import Prelude hiding ((++))

data List a = Nil | a :! (List a)
            deriving (Read, Show)

(++) :: List a-> List a-> List a
Nil ++ bs = bs
(a:! as) ++ bs = a :! (as ++ bs)

instance Functor List where
  fmap f Nil  = Nil
  fmap f (a:!as) = f a :! fmap f as

instance Applicative List where
  pure a = a :! Nil
  f :! fs <*> a :! as = f a :! (fs <*> as)
  _ <*> _ = Nil

instance Monad List where
  a :! as >>= g = g a ++ (as >>= g)
  Nil >>= g = Nil
  return a = a :! Nil
