module EvalStateful where

import Expr
import ReaderMonad
import qualified Data.Map as M

type State = M.Map String Double

eval :: Expr -> Reader State Double
eval (Var i)  = get (M.! i)
eval (Num n)  = return n
eval (Plus a b)  = do x<- eval a; y<- eval b; return $ x+ y
eval (Minus a b) = do x<- eval a; y<- eval b; return $ x- y
eval (Times a b) = do x<- eval a; y<- eval b; return $ x* y
eval (Div a b)   = do x<- eval a; y<- eval b; return $ x/ y

{-
-- Example:

s = M.fromList[("a", 3), ("b", 7)]
run (eval (Plus (Var "a") (Var "b"))) s

-}
