module EvalPartial where

import Expr

eval :: Expr -> Either String Double
eval (Var x)  = Left $ "No variable "++ x
eval (Num n)  = return n
eval (Plus a b)  = do x<- eval a; y<- eval b; return $ x+ y
eval (Minus a b) = do x<- eval a; y<- eval b; return $ x- y
eval (Times a b) = do x<- eval a; y<- eval b; return $ x* y
eval (Div a b)   = do
  x<- eval a; y<- eval b;
  if y == 0 then Left "Division by zero" else Right $ x/ y

{-
-- Examples:
eval (Plus (Num 3) (Div (Times (Num 4) (Num 5)) (Minus (Num 3) (Num 3))))
eval (Plus (Num 3) (Div (Times (Num 4) (Num 5)) (Minus (Num 4) (Num 3))))
-}
