module EvalND where

import Expr2

eval :: Expr -> [Double]
eval (Var i)  = return 0
eval (Num n)  = return n
eval (Plus a b)  = do x<- eval a; y<- eval b; return $ x+ y
eval (Minus a b) = do x<- eval a; y<- eval b; return $ x- y
eval (Times a b) = do x<- eval a; y<- eval b; return $ x* y
eval (Div a b)   = do x<- eval a; y<- eval b; return $ x/ y
eval (Pick a b)  = do x<- eval a; y<- eval b; [x, y]

{-
-- Examples:

eval (Plus (Num 3) (Pick (Num 4) (Num 5)))
eval (Times (Pick (Num 4) (Num 5)) (Pick (Num 1) (Num 0)))

-}
