module EvalFull where

import Prelude hiding (fail)
import Data.Maybe(fromMaybe)
import Control.Monad(zipWithM_)

import Expr2
import ResMonad hiding (run)
import qualified ResMonad
import qualified Data.Map as M

{-- eval --}
type State = M.Map String Double

eval :: Expr -> Res State Double
eval (Var i)  = get (\s-> case M.lookup i s of
                            Just x->  return x
                            Nothing-> Left $ "No such variable "++ i)
eval (Num n)  = return n
eval (Plus a b)  = do x<- eval a; y<- eval b; return $ x+ y
eval (Minus a b) = do x<- eval a; y<- eval b; return $ x- y
eval (Times a b) = do x<- eval a; y<- eval b; return $ x* y
eval (Div a b)   = do x<- eval a; y<- eval b
                      if y == 0 then fail "Divison by zero." else return $ x / y
eval (Pick a b)  = do x<- eval a; y<- eval b; join x y
{-- end --}

run :: [(String, Double)]-> Expr-> IO ()
run s e =
  zipWithM_ (\a b-> putStrLn (show a ++ " : " ++ b)) [1..]
          $ map (either ("ERROR: " ++) show)
          $ ResMonad.run (eval e) (M.fromList s)

{-
-- Examples:
s = [("a", 3), ("b", 7)]

run s $ Plus (Var "a") (Var "b")

run s $ Plus (Num 3) (Div (Var "b") (Minus (Num 3) (Var "a")))

run s $ Plus (Num 3) (Div (Var "a") (Var "b"))

run s $ Div (Pick (Var "a") (Num 5)) (Pick (Var "b") (Num 0))

run s $ Div (Pick (Var "a") (Num 5)) (Pick (Var "x") (Num 0))

-}
