{-- header --}
module Main where

import System.Environment (getArgs)
import Control.Exception
{-- end --}

-- Main function, reads command line arguments and counts wc2
{-- main --}
main :: IO ()
main = do 
  args <- getArgs
  putStrLn $ "Command line arguments: " ++ show args
  mapM_ wc2 args    
{-- end --}

-- The actual counting function
{-- wc --}
wc :: String-> IO ()
wc file = 
  do cont <- readFile file
     putStrLn $ file++ ": "++ 
                show (length (lines cont))++ " lines, " ++
                show (length (words cont))++ " words, "++
                show (length cont)++ " bytes."
{-- end --}

-- Wrap up wc in an error handler
{-- wc2 --}
wc2 :: String-> IO ()
wc2 file = 
  catch (wc file)
        (\e -> putStrLn $ "Fehler: "++ show (e :: IOError))
{-- end --}


