module Traverse where

import Control.Monad(filterM, mapM_)
import Control.Exception(catch)
import System.Directory
import System.FilePath((</>))
import Data.List((\\))
import System.Environment(getArgs)

travFS :: (FilePath-> IO ())-> FilePath-> IO ()
travFS action p = catch (do
    cs<- getDirectoryContents p
    let cp = map (p </>) (cs \\ [".", ".."])
    dirs  <- filterM doesDirectoryExist cp
{-  dirs  <- filterM (\c-> do r1 <- doesDirectoryExist c
                              r2 <- pathIsSymbolicLink c
                              return $ r1 && not r2) cp -}
    files <- filterM doesFileExist cp
    mapM_ action files
    mapM_ (travFS action) dirs)
  (\e -> putStrLn $ "ERROR: "++ show (e :: IOError))

main :: IO ()
main = do
  args <- getArgs
  mapM_ (travFS putStrLn) args

