module Random where

import System.Random(randomRIO)

-- Execute an action randomly often 
{-- atmost --}
atmost :: Int-> IO alpha-> IO [alpha]
atmost most a = 
  do l<- randomRIO (1, most)
     sequence (replicate l a)
{-- end --}

-- Use this to generate a random string
{-- randomstr --}
randomStr :: IO String
randomStr = atmost 40 (randomRIO ('a','z'))
{-- end --}