module Main where

import Stack
import Test.Tasty
import qualified Test.Tasty.QuickCheck as QC
import Test.Tasty.QuickCheck((==>))

-- Arbitrary-Instanz fr Stack
-- Erzeugt einen Stack zuflliger Lnge zwischen 0 und 20, 
-- gefllt mit zuflligen Werten.
instance QC.Arbitrary alpha=> QC.Arbitrary (St alpha) where
  arbitrary = do
    size <- QC.choose (0, 20) 
    els  <- QC.vector size     
    return $ foldr push empty els

main =
  defaultMain $ localOption (QC.QuickCheckTests 5000) $
    testGroup "All stack tests"
    [ QC.testProperty "top_push" $ \a s ->
        top (push a (s :: St Int)) == a
    , QC.testProperty "pop_push" $ \a s ->
        pop (push a (s :: St Int)) == s
    , QC.testProperty "push not empty" $ \a s ->
        empty /= push a (s:: St Int)
    ]

