module Main where

import Queue
import Test.Tasty
import qualified Test.Tasty.QuickCheck as QC
import Test.Tasty.QuickCheck((==>),(===))

-- Arbitrary-Instanz fr Queues
-- Erzeugt eine Queue zuflliger Lnge zwischen 0 und 20, 
-- gefllt mit zuflligen Werten.
instance QC.Arbitrary a=> QC.Arbitrary (Qu a) where
  arbitrary = do
    size <- QC.choose (0, 20)
    rsz  <- QC.choose (0, size `div` 5)
    els  <- QC.vector size     
    return $ foldr (\_ q-> deq q) (foldr enq empty els) [1.. rsz::Int]

main =
  defaultMain $ localOption (QC.QuickCheckTests 5000) $
    testGroup "All queue tests"
    [ QC.testProperty "first_empty" $ \a-> 
        first (enq a empty) == (a:: Int)
    , QC.testProperty "first_enq" $ \a q->
         q /= empty ==> first (enq a q) === first (q :: Qu Int)
    , QC.testProperty "deq_enq_empty" $ \a->
         deq (enq (a :: Int) empty) === empty
    , QC.testProperty "deq_enq" $ \a q->
         q /= empty ==> deq (enq a q) === enq a (deq (q :: Qu Int))
    , QC.testProperty "enq not empty" $ \a q->
         enq a (q ::Qu Int) /= empty
    ]
