{-# LANGUAGE FlexibleInstances #-}
module Main where

import Map
import Prelude hiding (lookup)    

import Test.Tasty
import qualified Test.Tasty.QuickCheck as QC
import Test.Tasty.QuickCheck((==>))

-- Arbitrary-Instanz fr Map. 
-- Erzeugt eine Map zuflliger Lnge zwischen 10 und 20,
-- gefllt mit zuflligen Werten.
instance (Ord a, QC.Arbitrary a, QC.Arbitrary b)=> QC.Arbitrary (Map a b) where
  arbitrary = do
    size <- QC.choose (10, 20)
    a <- QC.vector size
    b <- QC.vector size
    return (foldl (\s (a, v)-> insert a v s) empty (zip a b))

-- Die Eigenschaften (rich interface)

-- Lesen der leeren Map
prop1 :: TestTree
prop1 = QC.testProperty "read_empty" $ \a-> 
  lookup a (empty :: Map Int String) == Nothing 
 
-- Lesen an derselben Stelle
prop2 :: TestTree
prop2 = QC.testProperty "lookup_ins eq" $ \a v s->
  lookup a (insert a v (s :: Map Int String)) == Just v

prop3 :: TestTree
prop3 = QC.testProperty "lookup_del eq" $ \a s->
  lookup a (delete a (s :: Map Int String)) == Nothing

-- Lesen an anderer Stelle
prop4 :: TestTree
prop4 = QC.testProperty "lookup_ins other" $ \a b v s->
  a /= b ==> lookup a (insert b v s) == lookup a (s :: Map Int String)

-- Lesen an anderer Stelle
prop5 :: TestTree
prop5 = QC.testProperty "lookup_ins other" $ \a b s->
  a /= b ==> lookup a (delete b s) == lookup a (s :: Map Int String)

-- Insert/Insert an derselben Stelle
prop6 :: TestTree
prop6 = QC.testProperty "ins_ins eq" $ \a v w s->
  insert a w (insert a v s) == insert a w (s :: Map Int String)

-- Insert/Insert an anderer Stelle
prop7 :: TestTree
prop7 = QC.testProperty "ins_ins other" $ \a v b w s->
  a /= b ==> insert a v (insert b w s) == 
             insert b w (insert a v s :: Map Int String)

-- Insert/Delete an derselben Stelle
prop8 :: TestTree
prop8 = QC.testProperty "ins_del eq" $ \a w s->
  insert a w (delete a s) == insert a w (s :: Map Int String)

-- Insert/Delete an anderer Stelle
prop9 :: TestTree
prop9 = QC.testProperty "ins_del other" $ \a v b s->
  a /= b ==> insert a v (delete b s) == delete b (insert a v s :: Map Int String)

-- Delete/Insert an derselben Stelle
prop10 :: TestTree
prop10 = QC.testProperty "del_ins eq" $ \a v s->
  delete a (insert a v s) == delete a (s :: Map Int String)

-- Delete/Insert an anderer Stelle, same as prop9

-- Delete/Delete an derselben Stelle
prop11 :: TestTree
prop11 = QC.testProperty "del_del eq" $ \a s->
  delete a (delete a s) ==delete a (s :: Map Int String)

-- Insert/Insert an anderer Stelle
prop12 :: TestTree
prop12 = QC.testProperty "del_del other" $ \a b s->
  a /= b ==> delete a (delete b s) == 
             delete b (delete a (s :: Map Int String))

main =
  defaultMain $ localOption (QC.QuickCheckTests 5000) $
    testGroup "All map tests (rich interface)"
    [ prop1, prop2, prop3, prop4, prop5, prop6,
      prop7, prop8, prop9, prop10, prop11, prop12 ]

