module Stack (St, empty, push, pop, top) where

data St alpha = St [alpha]  deriving (Show, Eq)

empty :: St alpha
empty =  St []

push :: alpha-> St alpha-> St alpha
push a (St s) = St (a:s)

top  :: St alpha-> alpha
top  (St [])  = error "St: top on empty stack"
top  (St s)   = head s

pop  :: St alpha-> St alpha
pop  (St [])  = error "St: pop on empty stack"
pop  (St s)   = St (tail s)
