module MapList(
  Map, empty, lookup, put
  ) where

import Prelude hiding(lookup)
import Data.List((\\))

data Map alpha beta = Map [(alpha, beta)]

empty :: Map alpha beta
empty = Map []    

lookup :: Eq alpha=> alpha-> Map alpha beta-> Maybe beta
lookup a (Map s) = 
  case (filter ((a ==). fst) s) of 
    []        -> Nothing
    ((_,b):_) -> Just b

put :: Eq alpha=> alpha-> Maybe beta-> Map alpha beta-> Map alpha beta         
put a mv (Map s) = Map s' where
  s' = case mv of 
         Nothing  -> [(a', v) | (a', v)<- s, a /= a']
         Just val -> (insert' s) where
           insert' []       = [(a, val)]
           insert' ((b, w):s) | a == b    = (a, val): s 
                              | otherwise = (b, w): insert' s  

instance (Show alpha, Show beta)=> Show (Map alpha beta) where
  show (Map s) = show s

instance (Eq alpha, Eq beta)=> Eq (Map alpha beta) where
  Map s1 == Map s2 = 
    null (s1 \\ s2) && null (s1 \\ s2)
